package
{
	import org.flixel.*;

	public class MenuState extends FlxState
	{
		private var text:FlxText;
		private	var version:FlxText;
		private var splash:FlxSprite;
		
		[Embed(source = "data/images/splash_screen.png")] private var ImgSplashScreen:Class;

		public function MenuState()
		{
			splash = new FlxSprite(0,0,ImgSplashScreen);
			add(splash);
			
			text = new FlxText(16, 195, FlxG.width, "[---(Press Enter to Continue)---]");
			text.setFormat(null, 8, 0xFF000000, "center");
			add(text);
			
			version = new FlxText(7, 3, FlxG.width, "v1.2");
			version.setFormat(null, 8, 0xFF000000, "left");
			add(version);	
		}
		override public function update():void
		{
			super.update();
			if(FlxG.keys.ENTER)
				FlxG.fade(0xff000000, 1, fadeDone);
		}
		public function fadeDone():void
		{
			FlxG.switchState(new PlayState);
		}
	}
}