package
{
	import flash.events.TimerEvent;
	import flash.utils.Timer;
	import org.flixel.*;

	public class PlayState extends FlxState
	{
		private var level:FlxTilemap;
		private var player:Player;
		private var playerEvo:PlayerEvolve;
		private var gText:FlxText;
		
		private var goodGeneTimer:Timer;
		private var badGeneTimer:Timer;
		private var decreaseHealth:Timer;
		
		private var bar:FlxSprite;
		
		private var geneGroup:FlxGroup;
		private var badGeneGroup:FlxGroup;
		
		private var overHealth:Number = 100;
		private var isEvolved:Boolean = false;
		
		private var evolutionCount:Number = 10;
	
		[Embed(source = 'data/rooms/screen1.txt', mimeType = "application/octet-stream")] private var Map01Walls:Class;
		[Embed(source = 'data/images/floor_tiles.png')] private var ImgTileFloor:Class;
		
		public function PlayState()
		{
			FlxG.bgColor = 0xffFFFCFC;
			
			level = new FlxTilemap;
			level.loadMap(new Map01Walls, ImgTileFloor, 8, 8, FlxTilemap.OFF);
			add(level);
			
			player = new Player(16,32);
			add(player);
			
			playerEvo = new PlayerEvolve(16,32);
			
			overHealth = 150;
			
			var hud:FlxSprite = new FlxSprite(2,2);
			hud.makeGraphic(275,14,0xffffffff);
			add(hud);
			
			var hText:FlxText = new FlxText(2,2, FlxG.width, "Health:");
			hText.setFormat(null, 8, 0xFF000000, "left");
			add(hText);
			
			var frame:FlxSprite = new FlxSprite(40,4);
			frame.makeGraphic(152,10);
			add(frame);

			var inside:FlxSprite = new FlxSprite(42,5);
			inside.makeGraphic(150,8,0xff000000);
			add(inside);

			bar = new FlxSprite(42,5);
			bar.makeGraphic(1,8,0xff9adf5a); 
			bar.origin.x = bar.origin.y = 0;
			bar.scale.x = 150;
			add(bar);
			
			FlxG.score = 0;
			gText = new FlxText(200,2, FlxG.width, "Food: " + FlxG.score.toString());
			gText.setFormat(null, 8, 0xFF000000);
			add(gText);
			
			decreaseHealth = new Timer(1050, 1);
			decreaseHealth.addEventListener(TimerEvent.TIMER_COMPLETE, hurtPlr);
			decreaseHealth.start();
			
			goodGeneTimer = new Timer(1050, 2);
			goodGeneTimer.addEventListener(TimerEvent.TIMER_COMPLETE, addGene);
			goodGeneTimer.start();
			
			badGeneTimer = new Timer(2000, 2);
			badGeneTimer.addEventListener(TimerEvent.TIMER_COMPLETE, addBadGene);
			badGeneTimer.start();
			
			geneGroup = add(new FlxGroup()) as FlxGroup;
			badGeneGroup = add(new FlxGroup()) as FlxGroup;
			
			
		}
		override public function update():void
		{
			super.update();
			checkHealth();
			checkPlayer();
			FlxG.collide(level, playerEvo);
			FlxG.collide(level, player);
			FlxG.overlap(player, geneGroup, collectedGene);
			FlxG.overlap(player, badGeneGroup, collectedBadGene);
			FlxG.overlap(playerEvo, geneGroup, collectedGene);
			FlxG.overlap(playerEvo, badGeneGroup, collectedBadGene);
			
		}
		private function collectedGene(player:FlxObject, gene:FlxObject):void
		{
			gene.kill();
			FlxG.score += 1;
			gText.text = "Food: " + FlxG.score.toString();
			
			if (bar.scale.x >= 150)
			{
				bar.scale.x = 150;
			}
			else 
			{
				bar.scale.x += 12;	
			}
			overHealth += 12;
		}
		private function collectedBadGene(player:FlxObject, gene:FlxObject):void
		{
			gene.kill();
			FlxG.score -= 1;
			gText.text = "Food: " + FlxG.score.toString();
			
			overHealth -= 12
			
			if (bar.scale.x <= 35)
			{
				bar.color = 0xffFF3333;
			}
			else
			{
				bar.color = 0xff9adf5a;
			}
			bar.scale.x -= 12;
		}
		private function addGene(e:TimerEvent):void
		{
			var newG:Gene = new Gene();
			newG.x = Math.floor(Math.random()*(1+280-30))+30;
			newG.y = Math.floor(Math.random()*(1+219-30))+30;
			add(newG);
			geneGroup.add(newG);
			
			goodGeneTimer = new Timer(Math.floor(Math.random()*(1+1200-60))+30, 2);
			goodGeneTimer.addEventListener(TimerEvent.TIMER_COMPLETE, addGene);
			goodGeneTimer.start();
		}
		private function addBadGene(e:TimerEvent):void 
		{
			var newBadG:BadGene = new BadGene();
			newBadG.x = Math.floor(Math.random()*(1+280-30))+30;
			newBadG.y = Math.floor(Math.random()*(1+219-30))+30;
			add(newBadG);
			badGeneGroup.add(newBadG);
			
			badGeneTimer = new Timer(Math.floor(Math.random()*(1+2500-60))+30, 2);
			badGeneTimer.addEventListener(TimerEvent.TIMER_COMPLETE, addBadGene);
			badGeneTimer.start();
		}
		private function hurtPlr(e:TimerEvent):void
		{
			overHealth -= evolutionCount;
			
			if (bar.scale.x <= 35)
			{
				bar.color = 0xffFF3333;
			}
			else
			{
				bar.color = 0xff9adf5a;
			}
			bar.scale.x -= evolutionCount;
			decreaseHealth = new Timer(875, 1);
			decreaseHealth.addEventListener(TimerEvent.TIMER_COMPLETE, hurtPlr);
			decreaseHealth.start();
		}
		private function checkPlayer():void
		{
			if (FlxG.score >= 25)
			{
				if (!isEvolved)
				{
					remove(player);
					playerEvo.x = player.x;
					playerEvo.y = player.y;
					add(playerEvo);
					evolutionCount += 3;
					isEvolved = true;
				}
			}
		}
		private function checkHealth():void
		{
			if (overHealth <= 2)
			{
				decreaseHealth.stop();
				badGeneTimer.stop();
				goodGeneTimer.stop();
				remove(player);
				remove(playerEvo);
				FlxG.shake(0.05, 0.39, endGame, false,1);
			}
		}
		private function endGame():void 
		{
		   FlxG.switchState(new EndGame);	
		}
	}
}