package  
{
	import org.flixel.*;
	
	public class Player extends FlxSprite
	{
		[Embed(source = 'data/images/WalkLoop.png')] private var ImgWalk:Class;
		
		private var speed:uint = 135;
		
		public function Player(X:Number=0, Y:Number=0)
		{
			super(X,Y);
			
			loadGraphic(ImgWalk, true);
			addAnimation("WalkUp", [0, 1, 2], 10, false);
			addAnimation("WalkDown", [3, 4, 5], 10, false);
			addAnimation("WalkLeft", [6, 7, 8], 10, false);
			addAnimation("WalkRight", [9, 10, 11], 10, false);
		}
		
		override public function update():void
		{
			
			velocity.x = 0;
			velocity.y = 0;
			if (FlxG.keys.UP) 
			{
				play("WalkUp");
				velocity.y = -speed;
			} 
			else if (FlxG.keys.DOWN)
			{
				play("WalkDown");
				velocity.y = speed;
			} 
			else if (FlxG.keys.LEFT)
			{
				play("WalkLeft");
				velocity.x = -speed;
			} 
			else if (FlxG.keys.RIGHT) 
			{	
				play("WalkRight");
				velocity.x = speed;
			}
				
			super.update();
		}
	}

}